function JResizer(owner, sep, lPart, rPart) 
{
	var self = this,
	_isResizing = false,
	_orgMouseDown = null,
	_orgMouseUp = null,
	_orgMouseMove = null,
	_pos = null,
	_owner = owner,
	_sep = sep,
	_lPart = lPart,
	_rPart = rPart;

	this.dispose = dispose;
	this.onresize = new JEvent();

	initialize(_sep, _lPart, _rPart);

	function initialize(sep, lPart, rPart)
	{
		if ((sep == null) || (lPart == null) || (rPart == null))
			return;

        _orgMouseDown = sep.onmousedown;
		sep.onmousedown = function(args)
		{
			_isResizing = true;
			_orgMouseMove = this.parentNode.onmousemove;
			_orgMouseUp = this.parentNode.onmouseup;
			_pos = utils.getMouseXY(args);

			if ((_owner.isDebugEnabled) && (_owner.isDebugEnabled()))
			{
				
				var elem = _owner.getDocument().createElement('DIV');
				elem.id = '__appResizeInfo';
				elem.style.position = 'absolute';
				elem.style.top = '50';
				elem.style.left = '100';
				elem.style.width = '200';
				elem.style.height = '100';
				elem.style.zIndex = '50000';
				_owner.getDocument().body.appendChild(elem);
			}			

			sep.parentNode.onmousemove = function(args)
			{
				var btn = (args) ? ((args.which) ? args.which : args.button) : _owner.getWindow().event.button;

				if (btn == 0)
				{
					utils.cancelEvent(args);
					_sep.parentNode.onmouseup();
					return;
				}

				var elem = utils.getEventElement(args);
				var pos = utils.getMouseXY(args);
				var width = _owner.getDocument().body.clientWidth;
				var w = pos.x / width * 100;

				if ((pos.x < 10) || (w > 95))
				{
					utils.cancelEvent(args);
					return;
				}

				_lPart.style.width = w.toString() + '%';

				_sep.style.left = _lPart.style.width;

				_rPart.style.left = _lPart.style.width;
				_rPart.style.width = (99 - w).toString() + '%';

				if ((_owner.isDebugEnabled) && (_owner.isDebugEnabled()))
				{
					owner.$('__appResizeInfo').innerHTML = 
						'<div style="width:100%; height:100%; border: 1 solid black">' + 
						'btn:' + btn + '<br/>' + 
						'elem.id:' + elem.id + '<br/>' + 
						'pos-x:' + pos.x + '<br/>' + 
						'lPart-width:' + _lPart.style.width + '<br/>' + 
						'rPart-width:' + _rPart.style.width + '</div>';
				}

				if (_orgMouseMove != null)
					_orgMouseMove(args);
			}

			sep.parentNode.onmouseup = function(args)
			{
				stopResizing();
				self.onresize.raise(self);
				if (_orgMouseUp != null)
					_orgMouseUp(args);
			}
		}
	}

	function stopResizing()
	{
		if (_isResizing)
		{
			_isResizing = false;
			_sep.parentNode.onmousemove = _orgMouseMove;
			_sep.parentNode.onmouseup = _orgMouseUp;
			if (owner.$('__appResizeInfo') != null)
				owner.$('__appResizeInfo').parentNode.removeChild(owner.$('__appResizeInfo'));
		}
	}

	function dispose()
	{
		stopResizing();
		sep.onmousedown = _orgMouseDown;

		_orgMouseDown = null;
		_orgMouseUp = null;
		_orgMouseMove = null;

		self.onresize.dispose();
	}
}

if (typeof(loadNextScript) != 'undefined')
	loadNextScript();
